;DSG.ASM by Jonathan McDowell
;Copyright 1995 Jonathan McDowell for Project Purple.
;Display disk usage on a % bar.
;22/06/94 - Started writing.
;03/09/95 - Removed copyright display.
;         - Changed bug in % display when drive is 100% full.
;         - Removed trailing 0 when drive is less than 10% full.
;11/04/99 - Changed source format to assemble under NASM for release.

		org 100h
                jmp Main
PercentBarTop:  db 'Ŀ',13,10
                db ' Drive '
CurrentDrive    db 0
                db ': $'
PercentBarLow:  db '100% Used     ',13,10
                db '',13,10,'$'
YellowLimit     db 25
RedLimit        db 40
Main:           mov ah,19h
                int 21h
                mov [CurrentDrive],al		;Get current drive and make
                add BYTE [CurrentDrive],'A'		;it ASCII for display

                mov ah,36h
                mov dl,0
                int 21h
                mov cx,dx
                sub dx,bx
                mov bx,dx
                mov ax,100
                mul bx
                div cx
                push ax
                cmp al,100
                jz L1
                mov bl,10
                div bl
                add ax,'00'
                cmp al,'0'
		jnz NoTrailing0
                mov al,' '
NoTrailing0:	

                mov BYTE [PercentBarLow],' '
                mov BYTE [PercentBarLow+1],al
                mov BYTE [PercentBarLow+2],ah
L1:             mov dx,PercentBarTop
                mov ah,9
                int 21h

                mov ah,0Fh
                int 10h
                mov ah,9
                mov al,''
                mov cx,50                       ;Get current screen page and
                mov bl,0Fh                      ;write 50 of  to screen in
                int 10h                         ;bright white-ish

                pop cx                          ;Restore free space %
                shr cx,1                        ;divide by two for display

                cmp cl,[RedLimit]
                jb Yellow                       ;Check if over RedLimit and
                mov bl,0Ch                      ;if so print a red bar of
                call PrintBar                   ;length CX (ie %/2) and
                mov cl,[RedLimit]               ;set % to the RedLimit

Yellow:         cmp cl,[YellowLimit]
                jb Green
                mov bl,0Eh                      ;Same for YellowLimit except
                call PrintBar                   ;if actual % is over RedLimit
                mov cl,[YellowLimit]            ;then part of red is now yellow

Green:          mov bl,0Ah
                call PrintBar                   ;Print green bit

                mov ah,3
                int 10h                         ;Get current screen line
                mov ah,2
                mov dl,64
                int 10h                         ;Move cursor for % printing
                mov dx,PercentBarLow
                mov ah,9
                int 21h                         ;Print bottom part of gauge
                mov ax,4C00h
                int 21h                         ;Exit back to DOS

PrintBar:       mov ah,0Fh
                int 10h                         ;Get current screen page
                mov ah,9
                mov al,''                      ;Write CX chars of  in attr
                int 10h                         ;BL
                ret
