#!/usr/bin/perl -w
#
# add-dns.pl version 0.0.4alpha
# Dominic Hargreaves <dom@earth.li>
#
# Use this to tell nameservers supporting AutoDNS
# (http://www.earth.li/projectpurple/progs/autodns.html) to slave for you.
#
# Changelog:
#
# 03/07/01 dom: Added remotehelp and remove command for AutoDNS 0.0.4alpha
#               Changed to header to ns1 (from terry)
# 22/05/01 dom: Initial code completed for AutoDNS 0.0.3

use strict;
use IPC::Open3;

sub usage;

my $sendmail = "/usr/sbin/sendmail";
my $gpg = "/usr/bin/gpg";

my $to = 'dns-auto@tuschin.blackcatnetworks.co.uk,
      dns-auto@ns1.blackcatnetworks.co.uk';
#my $to = 'dom';
my $from = 'Urchin Hostmaster <hostmaster@urchin.earth.li>';
my $cc = $from;
#my $cc = "";
my $keyid = "25B2616D";
my $command;
my @validcommands = qw(add remove list remotehelp);

# Only proceed if we have been given a valid command

die usage unless $ARGV[0];

my $ok = 0;
for (@validcommands) {
   if ($ARGV[0] eq $_) {
      $ok = 1;
   }
}

die usage unless ($ok == 1);

# Open gpg filehandle

open3(\*GPGIN, \*GPGOUT, \*GPGERR, "$gpg --default-key $keyid --clearsign");

# Generate AutoDNS commands

print GPGIN "BEGIN\n";

$command = shift(@ARGV);

if ($command eq "list") {
   print GPGIN "LIST\n";
} elsif ($command eq "remotehelp") {
   print GPGIN "HELP\n";
} elsif ($command eq "add") {
   for (@ARGV) {
      print GPGIN "ADD $_\n";
   }
} elsif ($command eq "remove") {
   for (@ARGV) {
      print GPGIN "DEL $_\n";
   }
} else {
   die usage;
}

print GPGIN "END\n";

close GPGIN;

my @gpgerror=<GPGERR>;
my @gpgout=<GPGOUT>;
close GPGERR;
close GPGOUT;

# Show user any error output from gpg...

for (@gpgerror) {
   print STDERR $_;
}

# ...and what we intend to send

for (@gpgout) {
   print $_;
}

# Ask user whether this is ok

print "Send this mail to:\n";
print $to;
print "\nand\n";
print $cc;
print "\n? (y/n): ";

my $mark = "0";
while (<STDIN>) {
   if (/^y/i) {
      $mark = "1";
      last;
   }
   /^n/i and last;
}

if (!($mark eq "1")) {
   print "Mail NOT sent.\n";
   exit 1;
}

# Compose email

open MAIL, "|$sendmail -t -oi" or die $!;
print MAIL "From: $from\n" or die "Configuration error: $!";
print MAIL "To: $to\n" or die "Configuration error: $!";
print MAIL "Cc: $cc\n" if $cc;
print MAIL "Subject: AutoDNS commands\n";
print MAIL "X-Mailer: add-dns.pl 0.0.4alpha\n\n";

for (@gpgout) {
   print MAIL $_;
}

print MAIL "\n";

# Send email

close MAIL;

sub usage {
   print<<EOF;
Usage: $0 <command> [list of domains]

Possible commands: add: Adds domains
                   remove: Removes domains
                   list: Lists current domains
                   remotehelp: Requests help from remote end

(You must have the private key $keyid in your gpg keyring
for this to work)
EOF

}

